const CACHE_NAME = 'encanto-cache-v1';
const RUNTIME = 'runtime';

// Recursos que queremos cachear para offline
const PRECACHE_URLS = [
  '/',
  '/index.html',
  '/manifest.json',
  '/media/imagen-portada.webp',
  '/media/salon.webp',
  '/media/hab_cama_matrimonio.webp',
  '/media/hab_2_camas.webp',
  '/media/cocina.webp',
  '/fonts/your-main-font.woff2',
  '/_next/static/css/styles.css',
  '/favicon.ico',
  '/apple-touch-icon.png',
  '/favicon-32x32.png',
  '/favicon-16x16.png',
  '/safari-pinned-tab.svg'
];

// Durante la fase de instalación, generalmente se cachea lo estático
self.addEventListener('install', event => {
  event.waitUntil(
    caches.open(CACHE_NAME)
      .then(cache => cache.addAll(PRECACHE_URLS))
      .then(self.skipWaiting())
  );
});

// Una vez que se instala, se activa y busca los recursos para hacer que funcione sin conexión
self.addEventListener('activate', event => {
  const currentCaches = [CACHE_NAME, RUNTIME];
  event.waitUntil(
    caches.keys().then(cacheNames => {
      return cacheNames.filter(cacheName => !currentCaches.includes(cacheName));
    }).then(cachesToDelete => {
      return Promise.all(cachesToDelete.map(cacheToDelete => {
        return caches.delete(cacheToDelete);
      }));
    }).then(() => self.clients.claim())
  );
});

// Cuando el navegador recupera una url
self.addEventListener('fetch', event => {
  // Si la petición es a la API de calendario, siempre ir a la red
  if (event.request.url.includes('calendar.ics')) {
    event.respondWith(fetch(event.request));
    return;
  }

  // Para el resto de peticiones, intentar usar el cache primero
  event.respondWith(
    caches.match(event.request).then(cachedResponse => {
      if (cachedResponse) {
        return cachedResponse;
      }

      return caches.open(RUNTIME).then(cache => {
        return fetch(event.request).then(response => {
          // Poner en el cache si la respuesta es válida
          if (response.status === 200) {
            cache.put(event.request, response.clone());
          }
          return response;
        });
      });
    })
  );
}); 