// Deshabilitar stdin para evitar conflictos en hosting compartido
if (process.stdin && process.stdin.isTTY === false) {
  process.stdin.on("error", () => {}); // Ignorar errores de stdin
}

const { createServer } = require("http");
const { parse } = require("url");
const next = require("next");

const port = parseInt(process.env.PORT, 10) || 3000;
const dev = process.env.NODE_ENV !== "production";
const app = next({ dev });
const handle = app.getRequestHandler();

app.prepare().then(() => {
  const server = createServer((req, res) => {
    try {
      const parsedUrl = parse(req.url, true);
      handle(req, res, parsedUrl);
    } catch (err) {
      console.error("Server error:", err);
      res.statusCode = 500;
      res.end("Internal server error");
    }
  });

  server.on("error", (err) => {
    if (err.code === "EADDRINUSE" || err.code === "EEXIST") {
      console.error(`Port ${port} is already in use or socket exists`);
      process.exit(1);
    }
    console.error("Server error:", err);
    process.exit(1);
  });

  server.listen(port, (err) => {
    if (err) {
      console.error("Error starting server:", err);
      process.exit(1);
    }
    console.log("> Ready on port " + port);
  });

  // Cierre limpio para hosting gestionado
  process.on("SIGTERM", () => {
    console.log("SIGTERM received, shutting down server...");
    server.close(() => process.exit(0));
  });
  process.on("SIGINT", () => {
    console.log("SIGINT received, shutting down server...");
    server.close(() => process.exit(0));
  });
});
